<?php session_start(); ?>

<!DOCTYPE html>
<html lang="en">

<head>
    <?php include 'components/title-and-favicon.php'; ?>
</head>

<body>

    <!-- DASHBOARD CODE STARTS -->

    <!-- Sidebar Toggle Button Code Starts -->

    <button id="sidebarToggle" type="button" class="inline-flex items-center p-2 mt-2 ms-3 text-sm text-gray-500 rounded-lg sm:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200 dark:text-gray-400 dark:hover:bg-gray-700 dark:focus:ring-gray-600">
        <span class="sr-only">Open sidebar</span>
        <svg class="w-6 h-6" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
            <path clip-rule="evenodd" fill-rule="evenodd" d="M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zm0 10.5a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5a.75.75 0 01-.75-.75zM2 10a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 10z"></path>
        </svg>
    </button>

    <!-- Sidebar Toggle Button Code Ends -->

    <!-- Sidebar Code Starts -->

    <aside id="default-sidebar" class="fixed top-0 left-0 z-40 w-64 h-screen transition-transform -translate-x-full sm:translate-x-0 bg-gray-50 dark:bg-gray-800" aria-label="Sidebar">
        <div class="h-full px-3 py-4 overflow-y-auto">
            <ul class="space-y-2 font-medium">

                <?php echo "
                <li>
                    <a href='logout.php' class='flex items-center p-2 text-gray-900 rounded-lg dark:text-white hover:bg-gray-100 dark:hover:bg-gray-700 group'>
                        <span class='flex-1 ms-3 whitespace-nowrap'>Logout</span>
                    </a>
                </li>
                " ?>

            </ul>
        </div>
    </aside>

    <!-- Sidebar Code Ends -->

    <!-- Welcome Code Starts -->

    <div class="p-4 sm:ml-64">
        <p class="text-lg">

            <?php

            if (!isset($_SESSION['user_id'])) {
                header("Location: index.php");
                exit();
            }

            echo "Welcome, " . $_SESSION['username'];

            ?>

        </p>
    </div>

    <!-- Welcome Code Ends -->

    <script>
        const sidebar = document.getElementById("default-sidebar");
        const toggleButton = document.getElementById("sidebarToggle");

        toggleButton.addEventListener("click", () => {
            sidebar.classList.toggle("-translate-x-full");
        });
    </script>

    <!-- DASHBOARD CODE ENDS -->

</body>

</html>