<?php
session_start();
include 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, username, password FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($id, $username, $hashed_password);
        $stmt->fetch();

        if (password_verify($password, $hashed_password)) {
            $_SESSION['user_id'] = $id;
            $_SESSION['username'] = $username;
            header("Location: dashboard.php");
            exit();
        } else {
            echo "Invalid credentials!";
        }
    } else {
        echo "User not found!";
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
        <?php include 'components/title-and-favicon.php'; ?>
</head>
<body>

        <div class="h-screen md:flex">
                <div class="relative overflow-hidden md:flex w-1/2 bg-gradient-to-tr from-blue-800 to-purple-700 i justify-around items-center hidden">
                        <div>
                                <h1 class="text-white font-bold text-4xl font-sans">User Authentication</h1>
                                <p class="text-white mt-1">If you don't have an account please Sign Up</p>
                                <a href="register.php"><button type="button" class="block w-28 bg-white text-indigo-800 mt-4 py-2 rounded-2xl font-bold mb-2">Sign Up</button></a>
                        </div>
                        <div class="absolute -bottom-32 -left-40 w-80 h-80 border-4 rounded-full border-opacity-30 border-t-8"></div>
                        <div class="absolute -bottom-40 -left-20 w-80 h-80 border-4 rounded-full border-opacity-30 border-t-8"></div>
                        <div class="absolute -top-40 -right-0 w-80 h-80 border-4 rounded-full border-opacity-30 border-t-8"></div>
                        <div class="absolute -top-20 -right-20 w-80 h-80 border-4 rounded-full border-opacity-30 border-t-8"></div>
                </div>
                <div class="flex md:w-1/2 justify-center py-10 items-center bg-white">
                        <form class="bg-white" method="post">
                                <h1 class="text-gray-800 font-bold text-2xl mb-1">Hello Again!</h1>
                                <p class="text-sm font-normal text-gray-600 mb-7">Welcome Back</p>

                                <!-- Email Input Starts -->
                                <div class="flex items-center border-2 py-2 px-3 rounded-2xl mb-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207" />
                                        </svg>
                                        <input class="pl-2 outline-none border-none" type="email" name="email" id="email" placeholder="Email Address" required />
                                </div>
                                <!-- Email Input Ends -->

                                <!-- Password Input Starts -->
                                <div class="flex items-center border-2 py-2 px-3 rounded-2xl">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" viewBox="0 0 20 20"
                                                fill="currentColor">
                                                <path fill-rule="evenodd"
                                                        d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z"
                                                        clip-rule="evenodd" />
                                        </svg>
                                        <input class="pl-2 outline-none border-none" type="password" name="password" id="password" placeholder="Password" required />
                                </div>
                                <!-- Password Input Ends -->

                                <!-- Submit Button Starts -->
                                <button type="submit" class="block w-full bg-indigo-600 mt-4 py-2 rounded-2xl text-white font-semibold mb-2">Sign In</button>
                                <!-- Submit Button Ends -->
                        </form>
                </div>
        </div>

        <!-- Script Code Starts -->

        <script src="javascript/script.js"></script>

        <!-- Script Code Ends -->

</body>
</html>