<?php
include 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $username = $_POST['username'];
        $email = $_POST['email'];
        $password = password_hash($_POST['password'], PASSWORD_BCRYPT); // Encrypt password

        $stmt = $conn->prepare("INSERT INTO users (username, email, password) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $username, $email, $password);

        if ($stmt->execute()) {
                echo "<div id='toast-default' class='flex items-center w-full  p-4 text-gray-500 bg-white  shadow-sm dark:text-gray-400 dark:bg-gray-800' role='alert'>
        <div class='inline-flex items-center justify-center shrink-0 w-8 h-8 text-blue-500 bg-blue-100 rounded-lg dark:bg-blue-800 dark:text-blue-200'>
                <svg class='w-4 h-4' aria-hidden='true' xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 18 20'>
                        <path stroke='currentColor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M15.147 15.085a7.159 7.159 0 0 1-6.189 3.307A6.713 6.713 0 0 1 3.1 15.444c-2.679-4.513.287-8.737.888-9.548A4.373 4.373 0 0 0 5 1.608c1.287.953 6.445 3.218 5.537 10.5 1.5-1.122 2.706-3.01 2.853-6.14 1.433 1.049 3.993 5.395 1.757 9.117Z' />
                </svg>
                <span class='sr-only'>Your account was created successfully</span>
        </div>
        <div class='ms-3 text-sm font-normal'>Your account was created successfully. You can Sign in now from here <a href='login.php' class='sign-in'>Sign in now</a></div>
        <button type='button' class='ms-auto -mx-1.5 -my-1.5 bg-white text-gray-400 hover:text-gray-900 rounded-lg focus:ring-2 focus:ring-gray-300 p-1.5 hover:bg-gray-100 inline-flex items-center justify-center h-8 w-8 dark:text-gray-500 dark:hover:text-white dark:bg-gray-800 dark:hover:bg-gray-700' id='close-toast' aria-label='Close'>
                <span class='sr-only'>Close</span>
                <svg class='w-3 h-3' aria-hidden='true' xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 14 14'>
                        <path stroke='currentColor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6' />
                </svg>
        </button>
</div>";
        } else {
                echo "<div id='toast-default' class='flex items-center w-full  p-4 text-gray-500 bg-white  shadow-sm dark:text-gray-400 dark:bg-gray-800' role='alert'>
        <div class='inline-flex items-center justify-center shrink-0 w-8 h-8 text-blue-500 bg-blue-100 rounded-lg dark:bg-blue-800 dark:text-blue-200'>
                <svg class='w-4 h-4' aria-hidden='true' xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 18 20'>
                        <path stroke='currentColor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M15.147 15.085a7.159 7.159 0 0 1-6.189 3.307A6.713 6.713 0 0 1 3.1 15.444c-2.679-4.513.287-8.737.888-9.548A4.373 4.373 0 0 0 5 1.608c1.287.953 6.445 3.218 5.537 10.5 1.5-1.122 2.706-3.01 2.853-6.14 1.433 1.049 3.993 5.395 1.757 9.117Z' />
                </svg>
                <span class='sr-only'>This username already exists please choose another one</span>
        </div>
        <div class='ms-3 text-sm font-normal'>This username already exists please choose another one</div>
        <button type='button' class='ms-auto -mx-1.5 -my-1.5 bg-white text-gray-400 hover:text-gray-900 rounded-lg focus:ring-2 focus:ring-gray-300 p-1.5 hover:bg-gray-100 inline-flex items-center justify-center h-8 w-8 dark:text-gray-500 dark:hover:text-white dark:bg-gray-800 dark:hover:bg-gray-700' id='close-toast' aria-label='Close'>
                <span class='sr-only'>Close</span>
                <svg class='w-3 h-3' aria-hidden='true' xmlns='http://www.w3.org/2000/svg' fill='none' viewBox='0 0 14 14'>
                        <path stroke='currentColor' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6' />
                </svg>
        </button>
</div>";
        }

        // else {
        //         echo "This Username already exists" . $conn->error;
        // }

        $stmt->close();
        $conn->close();
}
?>


<!DOCTYPE html>
<html lang="en">

<head>
        <?php include 'components/title-and-favicon.php'; ?>
</head>

<body>

        <div class="h-screen md:flex">
                <div class="relative overflow-hidden md:flex w-1/2 bg-gradient-to-tr from-blue-800 to-purple-700 i justify-around items-center hidden">
                        <div>
                                <h1 class="text-white font-bold text-4xl font-sans">User Authentication</h1>
                                <p class="text-white mt-1">If you already have account please Sign In</p>
                                <a href="login.php"><button type="button" class="block w-28 bg-white text-indigo-800 mt-4 py-2 rounded-2xl font-bold mb-2">Sign In</button></a>
                        </div>
                        <div class="absolute -bottom-32 -left-40 w-80 h-80 border-4 rounded-full border-opacity-30 border-t-8"></div>
                        <div class="absolute -bottom-40 -left-20 w-80 h-80 border-4 rounded-full border-opacity-30 border-t-8"></div>
                        <div class="absolute -top-40 -right-0 w-80 h-80 border-4 rounded-full border-opacity-30 border-t-8"></div>
                        <div class="absolute -top-20 -right-20 w-80 h-80 border-4 rounded-full border-opacity-30 border-t-8"></div>
                </div>
                <div class="flex md:w-1/2 justify-center py-10 items-center bg-white">
                        <form class="bg-white" method="post">
                                <h1 class="text-gray-800 font-bold text-2xl mb-1">Hello Again!</h1>
                                <p class="text-sm font-normal text-gray-600 mb-7">Welcome Back</p>
                                <!-- Name Input Starts -->
                                <div class="flex items-center border-2 py-2 px-3 rounded-2xl mb-4">
                                        <img src="img/LOGO.png" class="h-5 w-5 text-gray-400" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M12 11c0 3.517-1.009 6.799-2.753 9.571m-3.44-2.04l.054-.09A13.916 13.916 0 008 11a4 4 0 118 0c0 1.017-.07 2.019-.203 3m-2.118 6.844A21.88 21.88 0 0015.171 17m3.839 1.132c.645-2.266.99-4.659.99-7.132A8 8 0 008 4.07M3 15.364c.64-1.319 1-2.8 1-4.364 0-1.457.39-2.823 1.07-4" />
                                        </img>
                                        <input class="pl-2 outline-none border-none" type="text" name="username" id="username" placeholder="Username" required />
                                </div>
                                <!-- Name Input Ends -->

                                <!-- Email Input Starts -->
                                <div class="flex items-center border-2 py-2 px-3 rounded-2xl mb-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" fill="none"
                                                viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207" />
                                        </svg>
                                        <input class="pl-2 outline-none border-none" type="email" name="email" id="email" placeholder="Email Address" required />
                                </div>
                                <!-- Email Input Ends -->

                                <!-- Password Input Starts -->
                                <div class="flex items-center border-2 py-2 px-3 rounded-2xl">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-gray-400" viewBox="0 0 20 20"
                                                fill="currentColor">
                                                <path fill-rule="evenodd"
                                                        d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z"
                                                        clip-rule="evenodd" />
                                        </svg>
                                        <input class="pl-2 outline-none border-none" type="password" name="password" id="password" placeholder="Password" required />
                                </div>
                                <!-- Password Input Ends -->

                                <!-- Submit Button Starts -->
                                <button type="submit" class="block w-full bg-indigo-600 mt-4 py-2 rounded-2xl text-white font-semibold mb-2">Sign Up</button>
                                <!-- Submit Button Ends -->
                        </form>
                </div>
        </div>

        <script src="javascript/script.js"></script>

</body>
</html>