<?php
session_start();
include('config.php');
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}
$id = $_GET['id'];
$stmt = $conn->prepare("SELECT * FROM posts WHERE id=?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$post = $result->fetch_assoc();
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = $_POST['title'];
    $content = $_POST['content'];
    $stmt = $conn->prepare("UPDATE posts SET title=?, content=? WHERE id=?");
    $stmt->bind_param("ssi", $title, $content, $id);
    $stmt->execute();
    header("Location: your-posts.php");
    exit();
}
?>

<!doctype html>
<html lang="en">
<head>
        <?php include 'components/title-and-favicon.php' ?>
</head>
<body>

        <!-- SIDEBAR CODE STARTS -->

        <!-- Sidebar Code Starts -->

        <div id="sidebar" class="sidebar">
                <a href="#" onclick="toggleSidebar()">Close ×</a>
                <a href="index.php">Home</a>
                <a href="your-posts.php">Your Posts</a>
                <a href="logout.php">Logout</a>
        </div>

        <!-- Sidebar Code Ends -->

        <!-- Page Content Code Starts -->

        <div class="content">
                <div class="container">
                        <button class="btn btn-primary" onclick="toggleSidebar()">☰ Toggle Sidebar</button>
                        <br><br>
                        <h1>BLOG CMS - DASHBOARD</h1>
                        <br>
                        <form method="post" action="">
                                <div class="form-group">
                                        <label for="title">Your Post Title</label>
                                        <input type="text" name="title" value="<?php echo htmlspecialchars($post['title']); ?>" required placeholder="Title" required class="form-control" aria-describedby="emailHelp">
                                </div>

                                <div class="form-group">
                                        <label for="password">Your Post Content</label>
                                        <textarea name="content" class="form-control" required><?php echo htmlspecialchars($post['content']);?></textarea>
                                </div>

                                <button type="submit" class="btn btn-primary">Update</button>

                                <br><br>

                                <p>Don't have an account? <a href="register.php">Register here</a></p>
                        </form>

                </div>
        </div>

        <!-- Page Content Code Ends -->

        <!-- Toggle Sidebar Script Code Starts -->

        <script>
                function toggleSidebar() {
                        let sidebar = document.getElementById("sidebar");
                        let content = document.querySelector(".content");
                        if (sidebar.style.left === "-250px") {
                                sidebar.style.left = "0";
                                content.style.marginLeft = "250px";
                        } else {
                                sidebar.style.left = "-250px";
                                content.style.marginLeft = "0";
                        }
                }
        </script>

        <!-- Toggle Sidebar Script Code Ends -->

        <!-- SIDEBAR CODE ENDS -->

        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-3.4.1.slim.min.js" integrity="sha384-J6qa4849blE2+poT4WnyKhv5vZF5SrPo0iEjwBvKU7imGFAV0wwj1yYfoRSJoZ+n" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js" integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/js/bootstrap.min.js" integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6" crossorigin="anonymous"></script>
</body>
</html>