<!doctype html>
<html lang="en">
<head>
        <?php include 'components/title-and-favicon.php' ?>
</head>
<body>

        <?php
        session_start();
        include('config.php');
        if (!isset($_SESSION['user'])) {
                header('Location: login.php');
                exit();
        }
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
                $title = $_POST['title'];
                $content = $_POST['content'];
                $id = isset($_POST['id']) ? $_POST['id'] : '';

                if ($id) {
                        $stmt = $conn->prepare("UPDATE posts SET title=?, content=? WHERE id=?");
                        $stmt->bind_param("ssi", $title, $content, $id);
                } else {
                        $stmt = $conn->prepare("INSERT INTO posts (title, content) VALUES (?, ?)");
                        $stmt->bind_param("ss", $title, $content);
                }
                $stmt->execute();
                header("Location: index.php");
                exit();
        }
        $posts = $conn->query("SELECT * FROM posts ORDER BY created_at DESC");
        ?>

        <!-- SIDEBAR CODE STARTS -->

        <!-- Sidebar Code Starts -->

        <div id="sidebar" class="sidebar">
                <a href="#" onclick="toggleSidebar()">Close ×</a>
                <a href="index.php">Home</a>
                <a href="your-posts.php">Your Posts</a>
                <a href="logout.php">Logout</a>
        </div>

        <!-- Sidebar Code Ends -->

        <!-- Page Content Code Starts -->

        <div class="content">
                <div class="container">
                        <button class="btn btn-primary" onclick="toggleSidebar()">☰ Toggle Sidebar</button>
                        <br><br>
                        <h1>BLOG CMS - YOUR POSTS</h1>
                        <br>

                        <?php while ($post = $posts->fetch_assoc()): ?>
                                <div>
                                        <br>
                                        <h3><?php echo htmlspecialchars($post['title']); ?></h3>
                                        <p><?php echo nl2br(htmlspecialchars($post['content'])); "<br>" ?></p>
                                        <button type="button" class="btn btn-info"><a style="text-decoration: none; color: white;" href="edit.php?id=<?php echo $post['id']; ?>">Edit</a></button>
                                        <button type="button" class="btn btn-danger"><a style="text-decoration: none; color: white;" href="delete.php?id=<?php echo $post['id']; ?>">Delete</a></button>
                                </div>
                        <?php endwhile; ?>

                </div>
        </div>

        <!-- Page Content Code Ends -->

        <!-- Toggle Sidebar Script Code Starts -->

        <script>
                function toggleSidebar() {
                        let sidebar = document.getElementById("sidebar");
                        let content = document.querySelector(".content");
                        if (sidebar.style.left === "-250px") {
                                sidebar.style.left = "0";
                                content.style.marginLeft = "250px";
                        } else {
                                sidebar.style.left = "-250px";
                                content.style.marginLeft = "0";
                        }
                }
        </script>

        <!-- Toggle Sidebar Script Code Ends -->

        <!-- SIDEBAR CODE ENDS -->

        <!-- Optional JavaScript -->
        <!-- jQuery first, then Popper.js, then Bootstrap JS -->
        <script src="https://code.jquery.com/jquery-3.4.1.slim.min.js" integrity="sha384-J6qa4849blE2+poT4WnyKhv5vZF5SrPo0iEjwBvKU7imGFAV0wwj1yYfoRSJoZ+n" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js" integrity="sha384-Q6E9RHvbIyZFJoft+2mJbHaEWldlvI9IOYy5n3zV9zzTtmI3UksdQRVvoxMfooAo" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/js/bootstrap.min.js" integrity="sha384-wfSDF2E50Y2D1uUdj0O3uMBJnjuUD4Ih7YwaYd1iqfktj0Uod8GCExl3Og8ifwB6" crossorigin="anonymous"></script>
</body>
</html>