Here's a simple URL shortener using PHP and MySQL.

### Steps:
1. **Create a Database**  
   ```sql
   CREATE DATABASE url_shortener;
   USE url_shortener;

   CREATE TABLE urls (
       id INT AUTO_INCREMENT PRIMARY KEY,
       long_url TEXT NOT NULL,
       short_code VARCHAR(10) NOT NULL UNIQUE,
       created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
   );
   ```
   
2. **Create the PHP Files**  
   Now, let's create the necessary PHP scripts.

---

### `config.php` - Database Connection
```php
<?php
$host = "localhost";
$user = "root"; // Change as per your DB credentials
$pass = "";
$dbname = "url_shortener";

$conn = new mysqli($host, $user, $pass, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
?>
```

---

### `shorten.php` - Shorten the URL
```php
<?php
include 'config.php';

function generateShortCode($length = 6) {
    return substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, $length);
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['long_url'])) {
    $long_url = trim($_POST['long_url']);
    
    if (!filter_var($long_url, FILTER_VALIDATE_URL)) {
        die("Invalid URL format");
    }
    
    $short_code = generateShortCode();
    
    $stmt = $conn->prepare("INSERT INTO urls (long_url, short_code) VALUES (?, ?)");
    $stmt->bind_param("ss", $long_url, $short_code);
    
    if ($stmt->execute()) {
        echo "Short URL: <a href='redirect.php?c=$short_code'>" . $_SERVER['HTTP_HOST'] . "/redirect.php?c=$short_code</a>";
    } else {
        echo "Error: " . $stmt->error;
    }
    
    $stmt->close();
}

$conn->close();
?>
```

---

### `redirect.php` - Redirect to Long URL
```php
<?php
include 'config.php';

if (isset($_GET['c'])) {
    $short_code = $_GET['c'];
    
    $stmt = $conn->prepare("SELECT long_url FROM urls WHERE short_code = ?");
    $stmt->bind_param("s", $short_code);
    $stmt->execute();
    $stmt->store_result();
    
    if ($stmt->num_rows > 0) {
        $stmt->bind_result($long_url);
        $stmt->fetch();
        header("Location: " . $long_url);
        exit();
    } else {
        echo "URL not found!";
    }
    
    $stmt->close();
}

$conn->close();
?>
```

---

### `index.html` - Simple Frontend
```html
<!DOCTYPE html>
<html>
<head>
    <title>URL Shortener</title>
</head>
<body>
    <h2>Enter a URL to Shorten</h2>
    <form action="shorten.php" method="POST">
        <input type="url" name="long_url" required>
        <button type="submit">Shorten</button>
    </form>
</body>
</html>
```

---

### How It Works:
1. **User submits a long URL** via `index.html`.
2. **`shorten.php` generates a short code**, saves it in the database, and displays the short URL.
3. **`redirect.php` retrieves the original URL** from the database and redirects the user.

Would you like to add custom short codes or tracking features? 🚀