<?php
include 'config.php';

function generateShortCode($length = 6) {
    return substr(str_shuffle("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"), 0, $length);
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['long_url'])) {
    $long_url = trim($_POST['long_url']);
    
    if (!filter_var($long_url, FILTER_VALIDATE_URL)) {
        die("Invalid URL format");
    }
    
    $short_code = generateShortCode();
    
    $stmt = $conn->prepare("INSERT INTO urls (long_url, short_code) VALUES (?, ?)");
    $stmt->bind_param("ss", $long_url, $short_code);
    
    if ($stmt->execute()) {
        echo "Short URL: <a href='redirect.php?c=$short_code'>" . $_SERVER['HTTP_HOST'] . "/redirect.php?c=$short_code</a>";
    } else {
        echo "Error: " . $stmt->error;
    }
    
    $stmt->close();
}

$conn->close();
?>