<?php
// Database connection
$host = 'localhost';
$dbname = 'event_booking';
$username = 'root';
$password = '';

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $event_date = $_POST['event_date'];
    $ticket_quantity = $_POST['ticket_quantity'];

    // Insert data into the database
    $stmt = $conn->prepare("INSERT INTO events (name, email, event_date, ticket_quantity) VALUES (:name, :email, :event_date, :ticket_quantity)");
    $stmt->bindParam(':name', $name);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':event_date', $event_date);
    $stmt->bindParam(':ticket_quantity', $ticket_quantity);

    if ($stmt->execute()) {
        echo "<div class='alert alert-success mt-4'>Booking successful! Thank you for registering.</div>";
    } else {
        echo "<div class='alert alert-danger mt-4'>Error occurred. Please try again.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Status</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <p><a href="index.html">Go back to booking form</a></p>
        <p><a href="view_bookings.php">View All Bookings</a></p>
    </div>
</body>
</html>