Here’s the complete implementation of the event booking system with **file names** included for better organization. Each file is clearly labeled, and the code is structured for easy understanding.

---

### File 1: `index.html` (Frontend - Booking Form)
This file contains the Bootstrap-based HTML form for event booking.

```html
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Event Booking System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">Event Booking System</h1>
        <form action="book_event.php" method="POST">
            <div class="mb-3">
                <label for="name" class="form-label">Full Name</label>
                <input type="text" class="form-control" id="name" name="name" required>
            </div>
            <div class="mb-3">
                <label for="email" class="form-label">Email Address</label>
                <input type="email" class="form-control" id="email" name="email" required>
            </div>
            <div class="mb-3">
                <label for="event_date" class="form-label">Event Date</label>
                <input type="date" class="form-control" id="event_date" name="event_date" required>
            </div>
            <div class="mb-3">
                <label for="ticket_quantity" class="form-label">Number of Tickets</label>
                <input type="number" class="form-control" id="ticket_quantity" name="ticket_quantity" min="1" required>
            </div>
            <button type="submit" class="btn btn-primary">Book Event</button>
        </form>
        <p class="mt-3"><a href="view_bookings.php">View All Bookings</a></p>
    </div>
</body>
</html>
```

---

### File 2: `book_event.php` (Backend - Handle Form Submission)
This file processes the form data and inserts it into the MySQL database.

```php
<?php
// Database connection
$host = 'localhost';
$dbname = 'event_booking';
$username = 'root';
$password = '';

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $email = $_POST['email'];
    $event_date = $_POST['event_date'];
    $ticket_quantity = $_POST['ticket_quantity'];

    // Insert data into the database
    $stmt = $conn->prepare("INSERT INTO events (name, email, event_date, ticket_quantity) VALUES (:name, :email, :event_date, :ticket_quantity)");
    $stmt->bindParam(':name', $name);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':event_date', $event_date);
    $stmt->bindParam(':ticket_quantity', $ticket_quantity);

    if ($stmt->execute()) {
        echo "<div class='alert alert-success mt-4'>Booking successful! Thank you for registering.</div>";
    } else {
        echo "<div class='alert alert-danger mt-4'>Error occurred. Please try again.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Status</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <p><a href="index.html">Go back to booking form</a></p>
        <p><a href="view_bookings.php">View All Bookings</a></p>
    </div>
</body>
</html>
```

---

### File 3: `view_bookings.php` (Display All Bookings)
This file fetches and displays all bookings from the database.

```php
<?php
// Database connection
$host = 'localhost';
$dbname = 'event_booking';
$username = 'root';
$password = '';

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// Fetch all bookings
$stmt = $conn->query("SELECT * FROM events ORDER BY created_at DESC");
$bookings = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Event Bookings</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="text-center mb-4">Event Bookings</h1>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Event Date</th>
                    <th>Tickets</th>
                    <th>Booked At</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($bookings as $booking): ?>
                    <tr>
                        <td><?php echo $booking['id']; ?></td>
                        <td><?php echo $booking['name']; ?></td>
                        <td><?php echo $booking['email']; ?></td>
                        <td><?php echo $booking['event_date']; ?></td>
                        <td><?php echo $booking['ticket_quantity']; ?></td>
                        <td><?php echo $booking['created_at']; ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <p><a href="index.html">Go back to booking form</a></p>
    </div>
</body>
</html>
```

---

### File 4: `database.sql` (Database Setup)
This file contains the SQL commands to create the database and table.

```sql
CREATE DATABASE event_booking;

USE event_booking;

CREATE TABLE events (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL,
    event_date DATE NOT NULL,
    ticket_quantity INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
```

---

### Folder Structure
Here’s how your project folder should look:

```
/event-booking-system/
│
├── index.html             # Booking form (Frontend)
├── book_event.php         # Handle form submission (Backend)
├── view_bookings.php      # Display all bookings
├── database.sql           # SQL file for database setup
```

---

### How to Run the Application
1. **Set up the database**:
   - Import `database.sql` into your MySQL server (e.g., using phpMyAdmin or MySQL CLI).
2. **Place files in the web server**:
   - Move the files (`index.html`, `book_event.php`, `view_bookings.php`) to your web server's root directory (e.g., `htdocs` for XAMPP).
3. **Access the application**:
   - Open your browser and navigate to `http://localhost/index.html`.

---

### Features to Add Later
- **Validation**: Add client-side (JavaScript) and server-side (PHP) validation.
- **User Authentication**: Allow users to log in and view their bookings.
- **Payment Integration**: Integrate a payment gateway like Stripe or PayPal.
- **Admin Panel**: Create an admin panel to manage events and bookings.

Let me know if you need help with any of these enhancements!