import React from "react";
import { BrowserRouter as Router, Route, Routes } from "react-router-dom";
import Navbar from "./components/Navbar";
import Home from "./pages/Home";
import OurMenu from "./pages/OurMenu";
import McCafe from "./pages/McCafe";
import Families from "./pages/Families";
import McDonald from "./pages/McDonald";
import Header from "./components/Header";
import BuyNow from "./pages/BuyNow";
import Footer from "./components/Footer";
import OrderNow from "./pages/OrderNow";

const App = () => {
  return (
    <Router>
      <Navbar />
      <Header></Header>
      <div className="p-4">
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/ourmenu" element={<OurMenu />} />
          <Route path="/mccafe" element={<McCafe />} />
          <Route path="/families" element={<Families />} />
          <Route path="/mcdonald" element={<McDonald />} />
          <Route path="/buynow" element={<BuyNow />} />
          <Route path="/ordernow" element={<OrderNow />} />
        </Routes>
      </div>
      <Footer></Footer>
    </Router>
  );
};

export default App;