import { useState } from "react";
import { Link } from "react-router-dom";

const Navbar = () => {
  // State to manage the menu toggle
  const [isMenuOpen, setIsMenuOpen] = useState(false);

  // Function to toggle menu visibility
  const toggleMenu = () => {
    setIsMenuOpen(!isMenuOpen);
  };

  return (
    <nav className="bg-white fixed w-full z-20 top-0 start-0 border-b border-gray-200 ">
      <div className="max-w-screen-xl flex flex-wrap items-center justify-between mx-auto p-4">
        {/* Logo */}
        <Link to="/" className="flex items-center space-x-3 rtl:space-x-reverse">
          <img src="https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcSRjLWhWpx9PfbzysffLbMA_DK_8jawJAVHbw&s" className="h-8" alt="Logo" />
        </Link>

        {/* Right Section: Button + Mobile Menu Toggle */}
        <div className="flex md:order-2 space-x-3 md:space-x-0 rtl:space-x-reverse">
          <Link to="/ordernow" type="button" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 " >
            Order Now
          </Link>

          {/* Mobile Menu Toggle Button */}
          <button
            onClick={toggleMenu}
            type="button"
            className="inline-flex items-center p-2 w-10 h-10 justify-center text-sm text-gray-500 rounded-lg md:hidden focus:ring-gray-200 dark:text-gray-400"
            aria-controls="navbar-sticky"
            aria-expanded={isMenuOpen}
            aria-label="Toggle navigation"
          >
            <span className="sr-only">Open main menu</span>
            <svg className="w-5 h-5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 17 14">
              <path stroke="currentColor" strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M1 1h15M1 7h15M1 13h15" />
            </svg>
          </button>
        </div>

        {/* Navbar Menu (Visible in Desktop, Hidden in Mobile unless toggled) */}
        <div className={`${isMenuOpen ? "block" : "hidden"} items-center justify-between w-full md:flex md:w-auto md:order-1`} id="navbar-sticky">
          <ul className="flex flex-col p-4 md:p-0 mt-4 font-medium border border-gray-100 rounded-lg  md:space-x-8 rtl:space-x-reverse md:flex-row md:mt-0 md:border-0 dark:border-gray-700">

            <li>
              <Link to="/ourmenu" className="block py-2 px-3 text-black rounded-sm md:bg-transparent md:text-yellow-300 md:p-0 md:dark:text-stone-950" aria-current="page" >Our Menu</Link>
            </li>

            <li>
              <Link to="/mccafe" className="block py-2 px-3 text-black rounded-sm md:bg-transparent md:text-yellow-300 md:p-0 md:dark:text-stone-950">Mc Cafe</Link>
            </li>

            <li>
              <Link to="/families" className="block py-2 px-3 text-black rounded-sm md:bg-transparent md:text-yellow-300 md:p-0 md:dark:text-stone-950">Families</Link>
            </li>

            <li>
              <Link to="/mcdonald" className="block py-2 px-3 text-black rounded-sm md:bg-transparent md:text-yellow-300 md:p-0 md:dark:text-stone-950">McDonald's</Link>
            </li>

          </ul>
        </div>
      </div>
    </nav>
  );
};

export default Navbar;