import React from "react";
import { Link } from "react-router-dom";

const Home = () => {
  return <div className="container mx-auto px-4">

    <div class="bg-white">
      <div class="mx-auto max-w-2xl px-4 py-16 sm:px-6 sm:py-24 lg:max-w-7xl lg:px-8">
        <div class="mt-6 grid grid-cols-1 gap-x-6 gap-y-10 sm:grid-cols-2 lg:grid-cols-4 xl:gap-x-8">

          <div class="group relative">
            <img src="https://mcdonalds.es/api/cms/images/mcdonalds-es/Z72KJp7c43Q3gLhg_FLASH_6McNuggets%C2%AE.png?auto=format,compress" alt="Front of men&#039;s Basic Tee in black." class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
                <h3 class="text-sm text-gray-700">
                  <Link to="/">
                    <span aria-hidden="true" class="absolute inset-0"></span>
                    This carnival... 6 McNuggets® for €1.50!
                  </Link>
                </h3>
                <p class="mt-1 text-sm text-gray-500">Live it up and enjoy it now!</p>
                <br />
                <Link to="/" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Learn More</Link>
              </div>
            </div>
          </div>

          <div class="group relative">
            <img src="https://mcdonalds.es/api/cms/images/mcdonalds-es/Zl2Cv6WtHYXtUAvJ_MyOrder-3-.jpg?auto=format,compress" class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
                <h3 class="text-sm text-gray-700">
                  <Link to="/">
                    <span aria-hidden="true" class="absolute inset-0"></span>
                    Do you want to skip the line?
                  </Link>
                </h3>
                <p class="mt-1 text-sm text-gray-500">With MyOrder, order and pay from wherever you want, doing whatever you want.</p>
                <br />
                <Link to="/" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Find Out</Link>
              </div>
            </div>
          </div>

          <div class="group relative">
            <img src="https://mcdonalds.es/api/cms/images/mcdonalds-es/Zgu9zct2UUcvBUtr_feature-call-mcdelivery.png?auto=format,compress" class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
                <h3 class="text-sm text-gray-700">
                  <Link to="/ordernow">
                    <span aria-hidden="true" class="absolute inset-0"></span>
                    Do you want McDonald's®? Order McDelivery®
                  </Link>
                </h3>
                <p class="mt-1 text-sm text-gray-500">Choose your favorite McMenu® and we'll take care of bringing it to you!</p>
                <br />
                <Link to="/ordernow" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Order Now</Link>
              </div>
            </div>
          </div>

          <div class="group relative">
            <img src="https://mcdonalds.es/api/cms/images/mcdonalds-es/Z5iWbJbqstJ996-g_MyMcD.jpg?auto=format,compress" class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
                <h3 class="text-sm text-gray-700">
                  <Link to="/">
                    <span aria-hidden="true" class="absolute inset-0"></span>
                    Surprises with MyMcDonald's®
                  </Link>
                </h3>
                <p class="mt-1 text-sm text-gray-500">Dive in and discover all the new features that MyMcDonald's has for you.</p>
                <br />
                <Link to="/" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Sign up</Link>
              </div>
            </div>
          </div>

        </div>

        <br /><br />

        <div class="relative flex flex-col md:flex-row w-full my-6 bg-white shadow-sm border border-slate-200 rounded-lg w-96">
          <div class="relative p-2.5 md:w-2/5 shrink-0 overflow-hidden">
            <img
              src="https://s7d1.scene7.com/is/image/mcdonalds/1Pub_QPC_AngelReese_2336x1040:1-column-desktop?resmode=sharp2"
              alt="card-image"
              class="h-full w-full rounded-md md:rounded-lg object-cover"
            />
          </div>
          <div class="p-6">
            <h4 class="mb-2 text-slate-800 text-xl font-semibold">The new QPC® and Angel got game 😇</h4>
            <p class="mb-8 text-slate-600 leading-normal font-light">
              You know you made it when you get your meal at McD’s. With an unapologetically bold, smoky BBQ sauce and crispy bacon, the new BBQ Bacon Quarter Pounder®* with Cheese is gonna change the game. Try yours in the Angel Reese Special today with medium fries and Hi-C® (or other soft drink). You can also get it a la carte as a single or double.^
            </p>
            <div>
              <Link to="" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Order in the App</Link>
            </div>
          </div>
        </div>


        <div class="relative flex flex-col md:flex-row w-full my-6 bg-white shadow-sm border border-slate-200 rounded-lg w-96">
          <div class="relative p-2.5 md:w-2/5 shrink-0 overflow-hidden">
            <img
              src="https://s7d1.scene7.com/is/image/mcdonalds/2025ShamrockShake_COM_1Pub_r3:1-column-desktop?resmode=sharp2"
              alt="card-image"
              class="h-full w-full rounded-md md:rounded-lg object-cover"
            />
          </div>
          <div class="p-6">
            <h4 class="mb-2 text-slate-800 text-xl font-semibold">Shamrock is back</h4>
            <p class="mb-8 text-slate-600 leading-normal font-light">
              Add some crunch to your life with the OREO® Shamrock McFlurry®. Or when you order the Shamrock Shake®, 25¢ is donated as a gift to Ronald McDonald House Charities® (RMHC®), thru 3/23.*
            </p>
            <div>
              <Link to="" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Get Your in the App</Link>
            </div>
          </div>
        </div>


        <div class="relative flex flex-col md:flex-row w-full my-6 bg-white shadow-sm border border-slate-200 rounded-lg w-96">
          <div class="relative p-2.5 md:w-2/5 shrink-0 overflow-hidden">
            <img
              src="https://s7d1.scene7.com/is/image/mcdonalds/_1PUB_McValue_V5:1-column-desktop?resmode=sharp2"
              alt="card-image"
              class="h-full w-full rounded-md md:rounded-lg object-cover"
            />
          </div>
          <div class="p-6">
            <h4 class="mb-2 text-slate-800 text-xl font-semibold">Wanna save $$? Meet McValue™</h4>
            <p class="mb-8 text-slate-600 leading-normal font-light">
              Get more than you expect (and for less) with meal deals, all-day deals, stuff-you-can’t-stop-thinking-about deals & more with the new McValue menu.
            </p>
            <div>
              <Link to="" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Order in the App</Link>
            </div>
          </div>
        </div>


        <div class="relative flex flex-col md:flex-row w-full my-6 bg-white shadow-sm border border-slate-200 rounded-lg w-96">
          <div class="relative p-2.5 md:w-2/5 shrink-0 overflow-hidden">
            <img
              src="https://s7d1.scene7.com/is/image/mcdonalds/1PUB_DigitalExperience_McDelivery:1-column-desktop?resmode=sharp2"
              alt="card-image"
              class="h-full w-full rounded-md md:rounded-lg object-cover"
            />
          </div>
          <div class="p-6">
            <h4 class="mb-2 text-slate-800 text-xl font-semibold">McDelivery® is where you get food. And free food.</h4>
            <p class="mb-8 text-slate-600 leading-normal font-light">
              Every McDelivery order in the app lets you earn MyMcDonald’s Rewards points—use those to get your free food. And, yup, you can get ‘em delivered, too. Imagine, McD’s you didn’t pay for brought right to you. Check out how easy ordering delivery is in the app.
            </p>
            <div>
              <Link to="" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Earn Points with McDelivery</Link>
            </div>
          </div>
        </div>


        <div class="relative flex flex-col md:flex-row w-full my-6 bg-white shadow-sm border border-slate-200 rounded-lg w-96">
          <div class="relative p-2.5 md:w-2/5 shrink-0 overflow-hidden">
            <img
              src="https://s7d1.scene7.com/is/image/mcdonalds/1PUB_RMHC_MyGift_2336x1040:1-column-desktop?resmode=sharp2"
              alt="card-image"
              class="h-full w-full rounded-md md:rounded-lg object-cover"
            />
          </div>
          <div class="p-6">
            <h4 class="mb-2 text-slate-800 text-xl font-semibold">50 years of Ronald McDonald House Charities®</h4>
            <p class="mb-8 text-slate-600 leading-normal font-light">
              McDonald’s is proud to be a Founding and Forever Partner of the Ronald McDonald House Charities, but it’s difficult to make a difference without your efforts. Thank you for impacting the lives of families when they need it most—in 2023, your donations helped raise over $200 million which provided over 2 million overnight stays.
              <br />
              <br />
              Continue leaving your mark with a gift to RMHC by selecting National RMHC Donation from the menu in the app or rounding up your order at the counter and Drive Thru.
            </p>
            <div>
              <Link to="" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Donate Now</Link>
            </div>
          </div>
        </div>


        <div class="relative flex flex-col md:flex-row w-full my-6 bg-white shadow-sm border border-slate-200 rounded-lg w-96">
          <div class="relative p-2.5 md:w-2/5 shrink-0 overflow-hidden">
            <img
              src="https://s7d1.scene7.com/is/image/mcdonalds/MDBBPG24035_2336x1040_CLGRP_WEBSITE_BANNER_5-20-2024:1-column-desktop?resmode=sharp2"
              alt="card-image"
              class="h-full w-full rounded-md md:rounded-lg object-cover"
            />
          </div>
          <div class="p-6">
            <h4 class="mb-2 text-slate-800 text-xl font-semibold">‘More Black Designers’ is the New Black</h4>
            <p class="mb-8 text-slate-600 leading-normal font-light">
              The 2024 McDonald’s Change of Fashion Program is focused on driving change when it comes to Black representation in fashion. The industry frequently pulls inspiration from Black culture, but doesn’t always embrace Black creatives. After all, only 7.3% of American fashion designers are Black.*<br />
              <br />
              So, we’re pairing five, rising Black designers with five fashion insiders for career-changing mentorships. The program will also provide access and resources, and give their brands a chance to shine.
            </p>
            <div>
              <Link to="" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Follow on Instagram</Link>
            </div>
          </div>
        </div>


        <div class="relative flex flex-col md:flex-row w-full my-6 bg-white shadow-sm border border-slate-200 rounded-lg w-96">
          <div class="relative p-2.5 md:w-2/5 shrink-0 overflow-hidden">
            <img
              src="https://s7d1.scene7.com/is/image/mcdonalds/1PUB_bestburger_trendingnow:1-column-desktop?resmode=sharp2"
              alt="card-image"
              class="h-full w-full rounded-md md:rounded-lg object-cover"
            />
          </div>
          <div class="p-6">
            <h4 class="mb-2 text-slate-800 text-xl font-semibold">“McD’s Best Burgers Ever.” - Hamburglar</h4>
            <p class="mb-8 text-slate-600 leading-normal font-light">
            You’re gonna love the hotter, juicier, tastier upgrades we’ve made to burgers like our Cheeseburger and Double Cheeseburger.* From patties grilled with onions and perfectly melted cheese to new soft, pillowy buns—these are our best burgers yet. Ask the Hamburglar, he can’t keep his hands off of ‘em. Robble, robble. 
            <br /><br />
            Get one today in the app for pickup or McDelivery®.^
            </p>
            <div>
              <Link to="" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Follow on Instagram</Link>
            </div>
          </div>
        </div>


        <div class="relative flex flex-col md:flex-row w-full my-6 bg-white shadow-sm border border-slate-200 rounded-lg w-96">
          <div class="relative p-2.5 md:w-2/5 shrink-0 overflow-hidden">
            <img
              src="https://s7d1.scene7.com/is/image/mcdonalds/1PUB_ROA_2336x1040:1-column-desktop?resmode=sharp2"
              alt="card-image"
              class="h-full w-full rounded-md md:rounded-lg object-cover"
            />
          </div>
          <div class="p-6">
            <h4 class="mb-2 text-slate-800 text-xl font-semibold">New: Faster Faves, Only in the App</h4>
            <p class="mb-8 text-slate-600 leading-normal font-light">
            We now prep when you’re on the way if you choose Curbside, Front Counter—or dine in for Table Service. Just order ahead in the app to save time. Because waiting in line for faves? Not our thing either.*
            </p>
            <div>
              <Link to="" className="text-stone-950 bg-blue-700 hover:bg-blue-800  focus:outline-none font-medium rounded-lg text-sm px-4 py-2 text-center dark:bg-yellow-300 dark:hover:bg-yellow-500 ">Order Ahead in the App</Link>
            </div>
          </div>
        </div>


      </div>
    </div>
  </div>
};

export default Home;