import React, { useState } from "react";

const Home = () => {
  const [isOpen, setIsOpen] = useState(false);

  return (
    <div className="bg-black text-white min-h-screen px-6 sm:px-10 md:px-16 lg:px-24">

      {/* Hero Section */}
      <header className="text-center mt-20 px-4 sm:px-0">
        <h2 className="text-3xl sm:text-4xl font-bold">Hi <span className="inline-block">👋</span></h2>
        <h1 className="text-4xl sm:text-5xl font-extrabold mt-2">I'm Ali Hamza,</h1>
        <h2 className="text-2xl sm:text-3xl text-purple-500 font-bold">Full Stack Developer</h2>
        <button className="mt-6 px-6 py-3 bg-purple-600 hover:bg-purple-700 rounded-lg text-white font-semibold" download="images/ENGLISH AND SPANISH CV PDF.pdf">
          <a href="" download="images/ENGLISH AND SPANISH CV PDF.pdf">
            Download my resume
          </a>
        </button>
      </header>

      {/* About Section */}
      <section className="max-w-4xl mx-auto mt-20 p-4 sm:p-6">
        <h3 className="text-2xl font-bold">A few words about <span className="text-purple-500">me</span></h3>
        <p className="mt-4 text-gray-300 text-sm sm:text-base">
          Dedicated Web Developer with strong skills in front-end and back-end technologies, including HTML, CSS, SCSS, Tailwind CSS, Bootstrap, JavaScript, React.js, PHP, and MySQL. Proficient in Git/GitHub and command-line tools. Familiar with UI/UX design principles and experienced in using Figma to create and refine user interfaces. Passionate about building responsive, efficient, and visually appealing websites. Always eager to learn and stay updated with the latest web technologies. In my free time, I enjoy playing badminton, which keeps me active and focused.
        </p>
      </section>

      {/* PHP Projects Section */}
      <section className="max-w-5xl mx-auto mt-16 p-4 sm:p-6">
        <h3 className="text-2xl font-bold">My latest <span className="text-purple-500">PHP </span>projects</h3>

        <div class="mt-6 grid grid-cols-1 gap-x-6 gap-y-10 sm:grid-cols-2 lg:grid-cols-4 xl:gap-x-8">

          <div class="group relative">
            <img src="https://alihamza.space/all-portfolio-projects/1.PERSONAL-PORTFOLIO-WEBSITE/personal-portfolio-project-image.png" alt="Front of men&#039;s Basic Tee in black." class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
              <p class="mt-2 text-sm text-stone-50"><b>PERSONAL PORTFOLIO PROJECT</b></p>
              <br />
                <h3 class="text-sm text-gray-700">
                  <button class="bg-purple-600 hover:bg-purple-800 text-white font-bold py-2 px-4 rounded-full">
                    <a href="https://alihamza.space/view-portfolio-project.php">View Project</a>
                  </button>
                </h3>
              </div>
            </div>
          </div>


          <div class="group relative">
            <img src="https://alihamza.space/all-portfolio-projects/2.USER-AUTHENTICATION-SYSTEM/user-authentication-system-image.png" alt="Front of men&#039;s Basic Tee in black." class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
              <p class="mt-2 text-sm text-stone-50"><b>USER AUTHENTICATION SYSTEM</b></p>
              <br />
                <h3 class="text-sm text-gray-700">
                  <button class="bg-purple-600 hover:bg-purple-800 text-white font-bold py-2 px-4 rounded-full">
                    <a href="https://alihamza.space/view-user-authentication-system.php">View Project</a>
                  </button>
                </h3>
              </div>
            </div>
          </div>


          <div class="group relative">
            <img src="https://alihamza.space/all-portfolio-projects/3.BLOG-CMS-CONTENT-MANAGEMENT-SYSTEM/blog-image.png" alt="Front of men&#039;s Basic Tee in black." class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
              <p class="mt-2 text-sm text-stone-50"><b>BLOG CMS CONTENT MANAGEMENT SYSTEM</b></p>
              <br />
                <h3 class="text-sm text-gray-700">
                  <button class="bg-purple-600 hover:bg-purple-800 text-white font-bold py-2 px-4 rounded-full">
                    <a href="https://alihamza.space/view-blog-cms.php">View Project</a>
                  </button>
                </h3>
              </div>
            </div>
          </div>


          <div class="group relative">
            <img src="https://alihamza.space/all-portfolio-projects/4.URL-SHORTNER/url-shortner-image.png" alt="Front of men&#039;s Basic Tee in black." class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
              <p class="mt-2 text-sm text-stone-50"><b>URL-SHORTNER</b></p>
              <br />
                <h3 class="text-sm text-gray-700">
                  <button class="bg-purple-600 hover:bg-purple-800 text-white font-bold py-2 px-4 rounded-full">
                    <a href="https://alihamza.space/view-url-shortner.php">View Project</a>
                  </button>
                </h3>
              </div>
            </div>
          </div>


          <div class="group relative">
            <img src="https://alihamza.space/all-portfolio-projects/5.STUDENT-MANAGEMENT-SYSTEM/student-management-system-image.png" alt="Front of men&#039;s Basic Tee in black." class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
              <p class="mt-2 text-sm text-stone-50"><b>STUDENT MANAGEMENT SYSTEM</b></p>
              <br />
                <h3 class="text-sm text-gray-700">
                  <button class="bg-purple-600 hover:bg-purple-800 text-white font-bold py-2 px-4 rounded-full">
                    <a href="https://alihamza.space/view-student-management-system.php">View Project</a>
                  </button>
                </h3>
              </div>
            </div>
          </div>


          <div class="group relative">
            <img src="https://alihamza.space/all-portfolio-projects/6.EVENT-BOOKING-SYSTEM/event-booking-system-image.png" alt="Front of men&#039;s Basic Tee in black." class="aspect-square w-full rounded-md bg-gray-200 object-cover group-hover:opacity-75 lg:aspect-auto lg:h-80" />
            <div class="mt-4 flex justify-between">
              <div>
              <p class="mt-2 text-sm text-stone-50"><b>EVENT BOOKING SYSTEM</b></p>
              <br />
                <h3 class="text-sm text-gray-700">
                  <button class="bg-purple-600 hover:bg-purple-800 text-white font-bold py-2 px-4 rounded-full">
                    <a href="https://alihamza.space/view-event-booking-system.php">View Project</a>
                  </button>
                </h3>
              </div>
            </div>
          </div>

        </div>

      </section>

      {/* Footer */}
      <footer className="text-center py-10 mt-20">
        <h3 className="text-3xl sm:text-4xl font-bold">Keep in <span className="text-purple-500">touch</span> ✉️</h3>
        <div className="flex justify-center space-x-4 mt-4">
          <a href="https://www.linkedin.com/in/hamza-the-developer/" className="text-gray-400 hover:text-white text-sm sm:text-base">LinkedIn</a>
          <a href="https://github.com/Hamza-Web-Developer" className="text-gray-400 hover:text-white text-sm sm:text-base">GitHub</a>
          <a href="https://www.instagram.com/hamza_the_developer/" className="text-gray-400 hover:text-white text-sm sm:text-base">Instagram</a>
        </div>
        <p className="mt-6 text-gray-500 text-sm sm:text-base">This is a portfolio project created by Muhammad Ali Hamza</p>
        <p className="mt-6 text-gray-500 text-sm sm:text-base">Contact : heythisishamza@gmail.com</p>
      </footer>

    </div>
  );
};

export default Home;